/**********************************************************************************************
	Container MacroScript File

	This file contains scripted commands related to Missing Plugin Entities Explorer
	
	Author:   Chengqing Zhou

	MODIFY THIS AT YOUR OWN RISK
***********************************************************************************************/

macroScript OpenMissingPluginEntitiesExplorer 
category:~OPEN_MISSING_PLUGIN_ENTITIES_EXPLORER_CATEGORY~  
internalCategory:"Scene Explorer" 
ButtonText:~OPEN_MISSING_PLUGIN_ENTITIES_EXPLORER_BUTTONTEXT~ 
tooltip:~OPEN_MISSING_PLUGIN_ENTITIES_EXPLORER_TOOLTIP~  
-- No icon yet
(
	on isEnabled return true
	on isChecked return false
	on isVisible do
	(
		plugInCount = SceneMissingPlugIns.GetMissingPlugInCount()
		ret = false
		-- if currently no missing plug-in, don't show it
		if ( plugInCount > 0) do
		(
			ret = true
		)
		return ret
	)

	on execute do
	(
		-- If the Missing Plugin Entities Explorer has not been loaded yet, do it now.
		-- We rely on the explorer name "Missing Plugin Entities Explorer" as defined in the 
		-- InstanceName field of the "DefaultMissingPluginEntitiesExplorer.ini" file.
		if not SceneExplorerManager.ExplorerExists ~OPEN_MISSING_PLUGIN_ENTITIES_EXPLORER_CAPTION~  then
		(
			local cfgpath = pathConfig.GetDir #plugcfg
			cfgpath = pathConfig.appendPath cfgpath "ExplorerConfig\SceneExplorer"
			local cfgfile = pathConfig.appendPath cfgpath "DefaultMissingPluginEntitiesExplorer.ini"
			SceneExplorerManager.LoadExplorerConfiguration cfgfile
		)
		SceneExplorerManager.OpenExplorer ~OPEN_MISSING_PLUGIN_ENTITIES_EXPLORER_TITLE~ 
	)
)

